from collections import Counter
from math import gcd

# Calculate gcd for list of numbers
def custom_gcd(*args):
    if len(args) == 1:
        return args[0]
    g = args[0]
    for k in args:
        g = gcd(g, k)
    return g

# Take input
D = int(input())
P = list(map(int, input().split()))
word = input()

# Count letter frequences and compute the gcd of their occurences
cnt = Counter(word)
g = custom_gcd(*cnt.values())

# Check if each position can be reached
for p in P:
    if p % g != 0:
        print('N')
        exit()
print('Y')
